/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.block.EnderAlternatorBlock;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.EnderCrafterContainer;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnderCrafterTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory = EnderCrafterTileEntity.createInventoryHandler(this::onContentsChanged);
    private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(9);
    private IEnderCrafterRecipe recipe;
    private int progress;
    private int progressReq;
    private boolean isGridChanged = true;

    public EnderCrafterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.ENDER_CRAFTER.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.progressReq = tag.m_128451_("ProgressReq");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("ProgressReq", this.progressReq);
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.extendedcrafting.ender_crafter").build();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return EnderCrafterContainer.create(windowId, playerInventory, arg_0 -> ((EnderCrafterTileEntity)this).isUsableByPlayer(arg_0), this.inventory, (ContainerData)new SimpleContainerData(0), this.m_58899_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnderCrafterTileEntity tile) {
        boolean mark = false;
        tile.updateRecipeInventory();
        Container recipeInventory = tile.recipeInventory.toIInventory();
        if (tile.isGridChanged && (tile.recipe == null || !tile.recipe.m_5818_(recipeInventory, level))) {
            tile.recipe = level.m_7465_().m_44015_(RecipeTypes.ENDER_CRAFTER, recipeInventory, level).orElse(null);
        }
        if (!level.m_5776_()) {
            if (tile.recipe != null) {
                ItemStack output;
                ItemStack result = tile.recipe.m_5874_(recipeInventory);
                if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)(output = tile.inventory.getStackInSlot(9)))) {
                    List<BlockPos> alternators = tile.getAlternatorPositions();
                    int alternatorCount = alternators.size();
                    if (alternatorCount > 0) {
                        tile.progress(alternatorCount, tile.recipe.getCraftingTime());
                        for (BlockPos alternatorPos : alternators) {
                            if (!level.m_46859_(alternatorPos.m_7494_())) continue;
                            tile.spawnParticles(ParticleTypes.f_123760_, alternatorPos, 1.0, 1);
                        }
                        if (tile.progress >= tile.progressReq) {
                            for (int i = 0; i < tile.inventory.getSlots() - 1; ++i) {
                                tile.inventory.extractItemSuper(i, 1, false);
                            }
                            tile.updateResult(result);
                            tile.progress = 0;
                        }
                        mark = true;
                    }
                } else if (tile.progress > 0 || tile.progressReq > 0) {
                    tile.progress = 0;
                    tile.progressReq = 0;
                    mark = true;
                }
            } else if (tile.progress > 0 || tile.progressReq > 0) {
                tile.progress = 0;
                tile.progressReq = 0;
                mark = true;
            }
            if (mark) {
                tile.markDirtyAndDispatch();
            }
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(10, onContentsChanged);
        inventory.setOutputSlots(new int[]{9});
        inventory.setSlotValidator((slot, stack) -> false);
        return inventory;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(9);
        if (result.m_41619_()) {
            this.inventory.setStackInSlot(9, stack);
        } else {
            this.inventory.setStackInSlot(9, StackHelper.grow((ItemStack)result, (int)stack.m_41613_()));
        }
    }

    private void updateRecipeInventory() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            this.recipeInventory.setStackInSlot(i, stack);
        }
    }

    private List<BlockPos> getAlternatorPositions() {
        ArrayList<BlockPos> alternators = new ArrayList<BlockPos>();
        Level level = this.m_58904_();
        if (level != null) {
            BlockPos pos = this.m_58899_();
            BlockPos.m_121990_((BlockPos)pos.m_142082_(-3, -3, -3), (BlockPos)pos.m_142082_(3, 3, 3)).forEach(aoePos -> {
                Block block = level.m_8055_(aoePos).m_60734_();
                if (block instanceof EnderAlternatorBlock) {
                    alternators.add(aoePos.m_7949_());
                }
            });
        }
        return alternators;
    }

    private void progress(int alternators, int timeRequired) {
        ++this.progress;
        int timeReq = 20 * timeRequired;
        double effectiveness = (Double)ModConfigs.ENDER_CRAFTER_ALTERNATOR_EFFECTIVENESS.get();
        this.progressReq = (int)Math.max((double)timeReq - (double)timeReq * (effectiveness * (double)alternators), 20.0);
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + yOffset;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void onContentsChanged() {
        this.isGridChanged = true;
        this.markDirtyAndDispatch();
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressRequired() {
        return this.progressReq;
    }

    public IEnderCrafterRecipe getActiveRecipe() {
        return this.recipe;
    }
}

